module deadline

import StdEnv, StdiTasks, iDataTrivial

derive gForm [], Maybe
derive gUpd  [], Maybe
derive gPrint    Maybe
derive gParse    Maybe
derive read		 Maybe
derive write	 Maybe

// (c) MJP 2007

// One can select a user to whom a task is delegated
// This user will get a certain amount of time to finish the task
// If the task is not finished on time, the task will be shipped back to the original user who has to do it instead
// It is also possible that the user becomes impatient and he can cancel the delegated task even though the deadline is not reached


npersons = 6

Start world = multiUserTask [ShowUsers npersons] (foreverTask (deadline mytask)) world

mytask = editTask "OK" 0 <| (\n -> if (n <= 42) (False,[Txt ("Error " <+++ n <+++ " should be larger than 42")]) (True,[]))

deadline :: (Task a) -> Task a | iData a
deadline task
=					[Txt "Choose person you want to delegate work to:",Br,Br] 
					?>>	editTask "Set" (PullDown (1,100) (0,map toString [1..npersons - 1])) 
	=>> \whomPD ->	[Txt "How long do you want to wait?",Br,Br] 
					?>>	editTask "SetTime" (Time 0 0 0) 
	=>> \time ->	[Txt "Cancel delegated work if you are getting impatient:",Br,Br] 
					?>> (delegateTask (toInt(toString whomPD)) time task
					-||-
					buttonTask "Cancel" (return_V Nothing))
	=>> 			CheckDone
where
	CheckDone (Just value)
	=	[Txt ("Result of task: " +++ printToString value),Br,Br] 
			?>>	buttonTask "OK" (return_V value)
	CheckDone nothing
	=	[Txt "Task expired or canceled, you have to do it yourself!",Br,Br] 
			?>>	buttonTask "OK" task

	delegateTask who time task
	= who  @: ("Timed Task",mytask)
	where
		mytask
		=			(			waitForTimerTask time 
					#>> 		return_V Nothing)									// return nothing
		 			-||-
		  			(			[Txt ("You have to complete the task in " <+++ time <+++ " time"),Br,Br] 	// tell deadline
								?>> task 
					=>> \v -> 	return_V (Just v))				// do task and return its result
